function [fourier_feat] =circle_fourier_transform(ROI_im,ROI_mask,max_radius,max_order,flag)
% max_order=23;
% if flag==1 , calculate magnitude only feature;
% if flag==2, calculate magnitude+ phase info. features;
F=ROI_im;

F1 = -1 + 2.*(F - min(F(:)))./(max(F(:)) - min(F(:)));

ROI_mask=imfill(ROI_mask);

% find edge points
ROI_e=edge(ROI_mask,'Sobel');
[xx, yy]=find_logical(ROI_e==1);

%% circle parameters
Par = CircleFitByKasa([yy xx]);

xCenter1=Par(1,1);
yCenter1=Par(1,2);


min_radius = max_radius/16;

%distance between the outermost and innermost circle
no_of_circles_inbw=10;
minDist=(max_radius-min_radius)/(no_of_circles_inbw+1);

% length of an arc=theta*r (theta in radian)
theta= linspace(0,2*pi,round((2*pi)/0.01)) ; % theta in radian

xr= xCenter1+max_radius.*cos(theta); % these points on circle are equally spaced
yr=yCenter1+ max_radius.*sin(theta);

scale= length(xr)/(2*pi*max_radius);


%no_of_points_min_radius=scale*(2*pi*min_radius);

rr=[];
% radius of the other 10 circles
for i=1:no_of_circles_inbw
    rr(1,i)=min_radius+i*minDist;
end

% let order for the largest circle be 23
% 0:23
rad=[min_radius rr max_radius];
rad1=[];

% order for each radius value
for j=1:size(rad,2)
    m_order(1,j)= round(max_order*(rad(1,j)/max_radius));
    rad1(1,j)=(m_order(1,j)*max_radius)/max_order; % adjust radius to give the exact order prescribed
end


[r1 c1]=size(F1);
%theta_r=-pi:0.01*pi:pi;


%theta_r=0:0.01:2*pi;
FD=[];
FD1={};
% move from largest to smallest circle and use different orders
fourier_moment_abs=[];
fourier_moment_real=[];
fourier_moment_imag=[];
figure;
imshow(F1,[]);
hold on;
parfor (i=1:size(rad1,2),29)
    
    no_of_points=round(scale*(2*pi*rad1(1,i)));
    theta1=linspace(0,2*pi,no_of_points) ;
     
     circle_x= xCenter1+rad(1,i)*cos(theta1);
     circle_y = yCenter1+rad(1,i)*sin(theta1);

     for I_2=1:size(circle_x,2)
       if circle_x(1,I_2)<1 
         %circle_x(1,I_2)=ceil(circle_x(1,I_2));
         circle_x(1,I_2)=1;
       elseif circle_x(1,I_2)> r1-1 & circle_x(1,I_2)<r1+1
         circle_x(1,I_2)=floor(circle_x(1,I_2));
       elseif circle_x(1,I_2)>r1+1
           circle_x(1,I_2)=r1;
       end
     
       if circle_y(1,I_2)<1 
         %circle_y(1,I_2)=ceil(circle_y(1,I_2));
         circle_y(1,I_2)=1;
       elseif circle_y(1,I_2)> c1-1 & circle_y(1,I_2)<c1+1
         circle_y(1,I_2)=floor(circle_y(1,I_2));
         elseif circle_y(1,I_2)>c1+1
           circle_y(1,I_2)=c1;
       end
     end
     circle_points=[circle_x;circle_y];
     r_e=circle_points';
     FD=round(r_e); %% find z values on the image for each of these points
     
     aa=[];
      for jj=1:size(FD,1)
             ee=F1(FD(jj,1),FD(jj,2));
             aa=[aa;ee]; %% values from the image
      end
      ord_no=m_order(1,i):-1:0;
      z=zeros(length(theta1),size(ord_no,2));
      for I_n2=1:size(ord_no,2)
      
          z(:,I_n2) = exp(-1i .*ord_no(I_n2).*theta1);
      
      end
       Moment=aa.*z;
       if flag==1
       fourier_moment_abs=[fourier_moment_abs abs(nansum(Moment,1))];
       end
       if flag==2
       fourier_moment_real=[fourier_moment_real real(nansum(Moment,1))];
       fourier_moment_imag=[fourier_moment_imag imag(nansum(Moment,1))]; % only difference has sign information
       end
       FD1{i}=aa; % this will lead to produce 64 absolute Fourier coeffs.
       hold on;
       plot(r_e(:,2),r_e(:,1),'g-')
    % end   
end

if flag==2
fourier_moment_r_im=[fourier_moment_real fourier_moment_imag]; 
fourier_moment_r_im1=fourier_moment_r_im(fourier_moment_r_im~=0);
end

if flag==1
    fourier_feat=fourier_moment_abs;
end
if flag==2
    fourier_feat=fourier_moment_r_im1;
end
end

